import Checkbox from '@mui/material/Checkbox';
import Paper from '@mui/material/Paper';
import Table from '@mui/material/Table';
import TableBody from '@mui/material/TableBody';
import TableCell from '@mui/material/TableCell';
import TableContainer from '@mui/material/TableContainer';
import TableHead from '@mui/material/TableHead';
import TableRow from '@mui/material/TableRow';
import { useEffect, useState } from 'react';

interface AppShellProps {
    children: React.ReactNode;
    title: string;
}
export default function TableView({ columns = [], dataset = [], showSelection = false }: AppShellProps) {
    const [tableColumn, setTableColumns] = useState([]);

    const [tableData, setTableData] = useState([]);

    const [selectedRecords,setSelectedRecords] = useState([]);


    const onSelectAllClick = (e) => {
      if(e.target.checked) {

      } else {
        setSelectedRecords([]);
      }
    }


    useEffect(() => {
        setTableColumns(columns);
        setTableData(dataset);
    }, [columns, dataset]);

    return (
        <TableContainer component={Paper}>
            <Table sx={{ minWidth: 650 }} aria-label="simple table">
                <TableHead>
                    <TableRow>
                        {showSelection && (
                            <TableCell padding="checkbox">
                                <Checkbox color="primary"
                                  onChange={onSelectAllClick}
                                />
                            </TableCell>
                        )}
                        {tableColumn.map((column) => (
                            <TableCell>{column.label}</TableCell>
                        ))}
                    </TableRow>
                </TableHead>
                <TableBody>
                    {tableData.map((record) => (
                        <>
                            <TableRow key={record.id}>
                                <>
                                    {showSelection && (
                                        <TableCell padding="checkbox">
                                            <Checkbox color="primary" />
                                        </TableCell>
                                    )}
                                    {tableColumn.map((column) => (
                                        <TableCell>{record[column.field] ?? '-'}</TableCell>
                                    ))}
                                </>
                            </TableRow>
                        </>
                    ))}
                </TableBody>
            </Table>
        </TableContainer>
    );
}
